﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.BusinessManager.EFR;
using System.Text.RegularExpressions;
using System.Web.Security.AntiXss;
public partial class DoDFragmentLab : BasePage
{
    private DoDFragmentManager _manager = new DoDFragmentManager();
    protected readonly string DoDFragmentPage = "DoDFragment.aspx?patientId=";

    protected void Page_Load(object sender, EventArgs e)
    {
        LoadBaseControls();

        if (!IsPostBack)
        {
            HiddenFieldPatientID.Value = AntiXssEncoder.HtmlEncode(Request.QueryString["patientId"], false);
            HiddenFieldDoDFragmentLabID.Value = AntiXssEncoder.HtmlEncode(Request.QueryString["dodFragmentLabId"], false);
        }

        DisplayPatientInfo();
    }

    private void Page_PreRender(object sender, EventArgs e)
    {
        LoadControlsFromObject();
    }

    private void DisplayPatientInfo()
    {
        if (!string.IsNullOrEmpty(Request.QueryString["patientId"]))
        {
            int patientId = Convert.ToInt32(AntiXssEncoder.HtmlEncode(Request.QueryString["patientId"], false));
            PatientManager patientManager = new PatientManager();
            PATIENT patient = patientManager.SelectByPatientID(patientId);

            if (patient != null)
            {
                if (string.IsNullOrEmpty(HiddenFieldDoDFragmentLabID.Value)
                    || HiddenFieldDoDFragmentLabID.Value == "0")
                {
                    BreadCrumbLabel.Text = "Patients > Patient Lookup > Workflows > DoD Fragment Data > Add Lab Data > " + patient.FullName;
                }
                else
                {
                    BreadCrumbLabel.Text = "Patients > Patient Lookup > Workflows > DoD Fragment Data > Edit Lab Data > " + patient.FullName;
                }
                BaseControlLabelPatientFullName.Text = patient.FullName;
                BaseControlLabelPatientSSN.Text = patient.Snum;
            }
        }
    }
    public override string TopMenuName()
    {
        return "Patients";
    }

    public override string AppObjectCode()
    {
        return "EFR_PATIENTS";
    }

    public override string MenuItemName()
    {
        return "EFR_PATIENTS";
    }

    private void LoadBaseControls()
    {
        RegistriesCommonManager commonManager = new RegistriesCommonManager();
        List<STD_GUI_CONTROL> controls = commonManager.GetStdGuiControlsByCategory("DOD_FRAGMENT_LAB_DATA_ENTRY", EFRSharedConstant.EfrRegistryId);

        foreach (STD_GUI_CONTROL dbItem in controls)
        {
            Control userControl = null;

            if (dbItem.BASE_CONTROL_TYPE == (int)EfrBaseControlType.Label)
            {
                userControl = PanelPatient.FindControl(dbItem.USER_CONTROL_ID);
                if (userControl != null)
                {
                    controls_BaseControlLabel baseControl = (controls_BaseControlLabel)userControl;
                    baseControl.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT,
                        dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL);
                }
            }
            else
            {
                userControl = PanelFragmentLabData.FindControl(dbItem.USER_CONTROL_ID);
                if (userControl != null)
                {
                    controls_BaseControlTextBox baseControl = (controls_BaseControlTextBox)userControl;
                    baseControl.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT,
                        dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL, dbItem.DATA_TYPE_MAX_LENGTH, dbItem.DATA_ELEMENT_WIDTH);
                }
            }
        }
    }


    protected void ButtonBack_Click(object sender, EventArgs e)
    {
        //Response.Redirect(String.Format("DoDFragment.aspx?patientId={0}", GetValidStringValue(HiddenFieldPatientID.Value)));
        ResponseRedirect(DoDFragmentPage, GetValidStringValue(HiddenFieldPatientID.Value));
    }


    protected void ButtonSave_Click(object sender, EventArgs e)
    {
        DOD_FRAGMENT_LAB lab = LoadObjectFromControls();
        lab = _manager.Update(lab);
        HiddenFieldDoDFragmentLabID.Value = lab.DOD_FRAGMENT_LAB_ID.ToString();

        //Response.Redirect(String.Format("DoDFragment.aspx?patientId={0}", GetValidStringValue(HiddenFieldPatientID.Value)));
        ResponseRedirect(DoDFragmentPage, GetValidStringValue(HiddenFieldPatientID.Value));
    }

    private string GetValidStringValue(string pCurrentQueue)
    {
        string currentQueue = string.Empty;
        if (pCurrentQueue != null)
        {
            if (Regex.IsMatch(pCurrentQueue, "^[a-zA-Z0-9]*$"))
            {
                currentQueue = pCurrentQueue;
            }
        }
        return currentQueue;
    }

    private DOD_FRAGMENT_LAB LoadObjectFromControls()
    {
        DOD_FRAGMENT_LAB lab = new DOD_FRAGMENT_LAB();

        if (!string.IsNullOrEmpty(HiddenFieldDoDFragmentLabID.Value))
        {
            //lab = (DOD_FRAGMENT_LAB)Session["DoDLab"];
            lab = SessionItemReference<DOD_FRAGMENT_LAB>.Get(Session["DoDLab"]);
            lab.SetAsChangeTrackingRoot(false);
            lab.SetAsUpdateOnSubmit();
        }
        else
        {
            lab.SetAsChangeTrackingRoot();
            lab.SetAsInsertOnSubmit();
            lab.PATIENT_ID = Helpers.getIntFromString(HiddenFieldPatientID.Value);
        }

        lab.LAB_NAME = BaseControlTextBoxLabName.Text;
        lab.LAB_REPORT_DATE = BaseControlTextBoxLabReportDate.Text;
        lab.LAB_CODE = BaseControlTextBoxLabCode.Text;
        lab.LAB_ID = BaseControlTextBoxLabID.Text;
        lab.LAB_ACCESSION_NUMBER = BaseControlTextBoxLabAccessionNumber.Text;
        lab.PRODUCING_EVENT_DATE = BaseControlTextBoxLabProducingEventDate.Text;

        return lab;
    }


    private void LoadControlsFromObject()
    {
        if (!string.IsNullOrEmpty(HiddenFieldDoDFragmentLabID.Value)
            && HiddenFieldDoDFragmentLabID.Value != "0")
        {
            DOD_FRAGMENT_LAB lab = _manager.GetDoDFragmentLabById(Helpers.getIntFromString(HiddenFieldDoDFragmentLabID.Value));
            BaseControlTextBoxLabName.Text = lab.LAB_NAME;
            BaseControlTextBoxLabReportDate.Text = lab.LAB_REPORT_DATE;
            BaseControlTextBoxLabCode.Text = lab.LAB_CODE;
            BaseControlTextBoxLabID.Text = lab.LAB_ID;
            BaseControlTextBoxLabAccessionNumber.Text = lab.LAB_ACCESSION_NUMBER;
            BaseControlTextBoxLabProducingEventDate.Text = lab.PRODUCING_EVENT_DATE;

            // Session["DoDLab"] = lab;//.Serialize();
            Session["DoDLab"] = SessionItemFactory.Create(lab);
        }
        else
        {
            Session["DoDLab"] = null;
        }
    }

    private void ResponseRedirect(string destination, string queryString)
    {
        try
        {
            string queryStringValue = string.Empty;
            if (queryString != null)
            {
                queryStringValue = AntiXssEncoder.UrlEncode(queryString);
            }

            string destinationUrl = string.Concat(destination, queryStringValue);
            string currentHost = Request.Url.Host;
            if (Helpers.IsDestinationUrlLocal(destinationUrl, currentHost))
            {
                //Response.Redirect(destinationUrl);
                Server.Transfer(destinationUrl);
            }
        }
        catch (Exception ex)
        {
            Logging.WriteLogToFile("Failure in to redirect to Export page: - DOD Fragment page.");
        }

    }
}
